/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.meta;

import java.util.Map;
import org.molgenis.vcf.meta.VcfMetaEntry;

public class VcfMetaFormat
extends VcfMetaEntry {
    private static final String KEY_ID = "ID";
    private static final String KEY_NUMBER = "Number";
    private static final String KEY_TYPE = "Type";
    private static final String KEY_DESCRIPTION = "Description";

    public VcfMetaFormat(Map<String, String> properties) {
        super(properties);
    }

    @Override
    public String getName() {
        return "FORMAT";
    }

    public String getId() {
        return (String)this.properties.get(KEY_ID);
    }

    public String getNumber() {
        return (String)this.properties.get(KEY_NUMBER);
    }

    public Type getType() {
        return Type.from((String)this.properties.get(KEY_TYPE));
    }

    public String getDescription() {
        return (String)this.properties.get(KEY_DESCRIPTION);
    }

    public static enum Type {
        INTEGER("Integer"),
        FLOAT("Float"),
        CHARACTER("Character"),
        STRING("String");

        private String type;

        private Type(String type) {
            this.type = type;
        }

        public static Type from(String str) {
            for (Type type : Type.values()) {
                if (!type.toString().equals(str)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.type;
        }
    }
}

