/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.tabix;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.RawLineQuery;
import org.molgenis.genotype.RawLineQueryResult;
import org.molgenis.genotype.tabix.TabixIndex;
import org.molgenis.genotype.tabix.TabixRawLineQueryResult;

public class TabixRawLineQuery
implements RawLineQuery {
    private BlockCompressedInputStream inputStream;
    private final TabixIndex index;

    public TabixRawLineQuery(File bzipFile, TabixIndex index) {
        if (bzipFile == null) {
            throw new IllegalArgumentException("BzipFile is null");
        }
        if (index == null) {
            throw new IllegalArgumentException("Index is null");
        }
        try {
            this.inputStream = new BlockCompressedInputStream(bzipFile);
        }
        catch (IOException e) {
            throw new GenotypeDataException("IOExcption creating BlockCompressedInputStream for " + bzipFile.getName(), e);
        }
        this.index = index;
    }

    @Override
    public RawLineQueryResult executeQuery(String sequence, int startPos) {
        if (startPos < 0) {
            throw new IllegalArgumentException("StartPos must be bigger then 0");
        }
        try {
            TabixIndex.TabixIterator tabixIterator = this.index.queryTabixIndex(sequence, startPos - 1, startPos, this.inputStream);
            return new TabixRawLineQueryResult((InputStream)this.inputStream, new RawLineIterator(tabixIterator));
        }
        catch (IOException e) {
            throw new GenotypeDataException(e);
        }
    }

    private static class RawLineIterator
    implements Iterator<String> {
        private TabixIndex.TabixIterator tabixIterator;
        private String line;

        private RawLineIterator(TabixIndex.TabixIterator tabixIterator) throws IOException {
            this.tabixIterator = tabixIterator;
            this.line = tabixIterator == null ? null : tabixIterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public String next() {
            String result = this.line;
            try {
                this.line = this.tabixIterator.next();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception calling next on TabixIndex.TabixIterator", e);
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

