/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.sampleFilter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.sampleFilter.SampleFilterableGenotypeData;
import org.molgenis.genotype.util.FixedSizeIterable;
import org.molgenis.genotype.util.Ld;
import org.molgenis.genotype.util.LdCalculatorException;
import org.molgenis.genotype.util.MafCalculator;
import org.molgenis.genotype.util.MafResult;
import org.molgenis.genotype.variant.AbstractGeneticVariant;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.genotype.variant.id.GeneticVariantId;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class SampleFilteredReadOnlyGeneticVariant
extends AbstractGeneticVariant {
    private final GeneticVariant original;
    private final SampleFilterableGenotypeData genotypeData;

    public SampleFilteredReadOnlyGeneticVariant(GeneticVariant original, SampleFilterableGenotypeData genotypeData) {
        this.original = original;
        this.genotypeData = genotypeData;
    }

    @Override
    public String getPrimaryVariantId() {
        return this.original.getPrimaryVariantId();
    }

    @Override
    public List<String> getAlternativeVariantIds() {
        return this.original.getAlternativeVariantIds();
    }

    @Override
    public List<String> getAllIds() {
        return this.original.getAllIds();
    }

    @Override
    public GeneticVariantId getVariantId() {
        return this.original.getVariantId();
    }

    @Override
    public int getStartPos() {
        return this.original.getStartPos();
    }

    @Override
    public String getSequenceName() {
        return this.original.getSequenceName();
    }

    @Override
    public Alleles getVariantAlleles() {
        return this.original.getVariantAlleles();
    }

    @Override
    public int getAlleleCount() {
        return this.original.getAlleleCount();
    }

    @Override
    public Allele getRefAllele() {
        return this.original.getRefAllele();
    }

    @Override
    public Alleles getAlternativeAlleles() {
        return this.original.getAlternativeAlleles();
    }

    @Override
    public List<Alleles> getSampleVariants() {
        ArrayList<Alleles> sampleAlleles = new ArrayList<Alleles>(this.original.getSampleVariants());
        Iterator<Alleles> sampleAllelesIterator = sampleAlleles.iterator();
        Iterator<Sample> sampleIterator = this.genotypeData.getOriginalSampleList().iterator();
        try {
            while (sampleAllelesIterator.hasNext()) {
                sampleAllelesIterator.next();
                if (this.genotypeData.getSampleFilter().doesSamplePassFilter(sampleIterator.next())) continue;
                sampleAllelesIterator.remove();
            }
        }
        catch (NoSuchElementException e) {
            throw new GenotypeDataException("Error in filtering on included samples. More alleles than samples detected", e);
        }
        return Collections.unmodifiableList(sampleAlleles);
    }

    @Override
    public Map<String, ?> getAnnotationValues() {
        return this.original.getAnnotationValues();
    }

    @Override
    public double getMinorAlleleFrequency() {
        try {
            MafResult mafResult = MafCalculator.calculateMaf(this.getVariantAlleles(), this.getRefAllele(), this.getSampleVariants());
            return mafResult.getFreq();
        }
        catch (NullPointerException e) {
            throw new GenotypeDataException("NullPointerException in maf caculation. " + this.getVariantAlleles() + " ref: " + this.getRefAllele(), e);
        }
    }

    @Override
    public Allele getMinorAllele() {
        try {
            MafResult mafResult = MafCalculator.calculateMaf(this.getVariantAlleles(), this.getRefAllele(), this.getSampleVariants());
            return mafResult.getMinorAllele();
        }
        catch (NullPointerException e) {
            throw new GenotypeDataException("NullPointerException in maf caculation. " + this.getVariantAlleles() + " ref: " + this.getRefAllele(), e);
        }
    }

    @Override
    public boolean isSnp() {
        return this.original.isSnp();
    }

    @Override
    public boolean isAtOrGcSnp() {
        return this.original.isAtOrGcSnp();
    }

    @Override
    public Ld calculateLd(GeneticVariant other) throws LdCalculatorException {
        return this.original.calculateLd(other);
    }

    @Override
    public boolean isBiallelic() {
        return this.original.isBiallelic();
    }

    @Override
    public float[] getSampleDosages() {
        float[] unfilteredDosages = this.original.getSampleDosages();
        float[] includedSamplesDosages = new float[this.genotypeData.getIncludedSampleCount()];
        Iterator<Sample> sampleIterator = this.genotypeData.getOriginalSampleList().iterator();
        try {
            int i = 0;
            for (float dosage : unfilteredDosages) {
                if (!this.genotypeData.getSampleFilter().doesSamplePassFilter(sampleIterator.next())) continue;
                includedSamplesDosages[i] = dosage;
                ++i;
            }
        }
        catch (NoSuchElementException e) {
            throw new GenotypeDataException("Error in filtering on included samples. More dosage values than samples detected", e);
        }
        return includedSamplesDosages;
    }

    @Override
    public byte[] getSampleCalledDosages() {
        byte[] unfilteredDosages = this.original.getSampleCalledDosages();
        byte[] includedSamplesDosages = new byte[this.genotypeData.getIncludedSampleCount()];
        Iterator<Sample> sampleIterator = this.genotypeData.getOriginalSampleList().iterator();
        try {
            int i = 0;
            for (byte dosage : unfilteredDosages) {
                if (!this.genotypeData.getSampleFilter().doesSamplePassFilter(sampleIterator.next())) continue;
                includedSamplesDosages[i] = dosage;
                ++i;
            }
        }
        catch (NoSuchElementException e) {
            throw new GenotypeDataException("Error in filtering on included samples. More dosage values than samples detected", e);
        }
        return includedSamplesDosages;
    }

    @Override
    public List<Boolean> getSamplePhasing() {
        ArrayList<Boolean> samplePhasing = new ArrayList<Boolean>(this.original.getSamplePhasing());
        Iterator<Boolean> samplePhasingIterator = samplePhasing.iterator();
        Iterator<Sample> sampleIterator = this.genotypeData.getOriginalSampleList().iterator();
        try {
            while (samplePhasingIterator.hasNext()) {
                samplePhasingIterator.next();
                if (this.genotypeData.getSampleFilter().doesSamplePassFilter(sampleIterator.next())) continue;
                samplePhasingIterator.remove();
            }
        }
        catch (NoSuchElementException e) {
            throw new GenotypeDataException("Error in filtering on included samples. More alleles than samples detected", e);
        }
        return Collections.unmodifiableList(samplePhasing);
    }

    @Override
    public float[][] getSampleGenotypeProbilities() {
        float[][] unfilteredProbs = this.original.getSampleGenotypeProbilities();
        float[][] includedSamplesProbs = new float[this.genotypeData.getIncludedSampleCount()][3];
        Iterator<Sample> sampleIterator = this.genotypeData.getOriginalSampleList().iterator();
        try {
            int i = 0;
            for (float[] prob : unfilteredProbs) {
                if (!this.genotypeData.getSampleFilter().doesSamplePassFilter(sampleIterator.next())) continue;
                includedSamplesProbs[i] = prob;
                ++i;
            }
        }
        catch (NoSuchElementException e) {
            throw new GenotypeDataException("Error in filtering on included samples. More prob values than samples detected", e);
        }
        return includedSamplesProbs;
    }

    @Override
    public SampleVariantsProvider getSampleVariantsProvider() {
        return this.original.getSampleVariantsProvider();
    }

    @Override
    public GeneticVariantMeta getVariantMeta() {
        return this.original.getVariantMeta();
    }

    @Override
    public FixedSizeIterable<GenotypeRecord> getSampleGenotypeRecords() {
        final Iterator originalRecords = this.original.getSampleGenotypeRecords().iterator();
        return new FixedSizeIterable<GenotypeRecord>(){

            @Override
            public int size() {
                return SampleFilteredReadOnlyGeneticVariant.this.genotypeData.getIncludedSampleCount();
            }

            @Override
            public Iterator<GenotypeRecord> iterator() {
                return new Iterator<GenotypeRecord>(){
                    int i = 0;
                    Iterator<Sample> sampleIterator;
                    {
                        this.sampleIterator = SampleFilteredReadOnlyGeneticVariant.this.genotypeData.getOriginalSampleList().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < SampleFilteredReadOnlyGeneticVariant.this.genotypeData.getIncludedSampleCount();
                    }

                    @Override
                    public GenotypeRecord next() {
                        if (this.i < SampleFilteredReadOnlyGeneticVariant.this.genotypeData.getIncludedSampleCount()) {
                            try {
                                while (originalRecords.hasNext()) {
                                    GenotypeRecord x = (GenotypeRecord)originalRecords.next();
                                    if (!SampleFilteredReadOnlyGeneticVariant.this.genotypeData.getSampleFilter().doesSamplePassFilter(this.sampleIterator.next())) continue;
                                    ++this.i;
                                    return x;
                                }
                                throw new GenotypeDataException("Error in filtering on included samples.");
                            }
                            catch (NoSuchElementException e) {
                                throw new GenotypeDataException("Error in filtering on included samples. More records than samples detected", e);
                            }
                        }
                        throw new GenotypeDataException("Error in filtering on included samples.");
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }
        };
    }
}

